/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiTankBar;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.network.to_server.PacketDropperUse;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;

public class GuiFluidBar
extends GuiTankBar<FluidStack> {
    public GuiFluidBar(IGuiWrapper gui, GuiTankBar.TankInfoProvider<FluidStack> infoProvider, int x, int y, int width, int height, boolean horizontal) {
        super(gui, infoProvider, x, y, width, height, horizontal);
    }

    @Override
    protected boolean isEmpty(FluidStack stack) {
        return stack.isEmpty();
    }

    @Override
    protected PacketDropperUse.TankType getType(FluidStack stack) {
        return PacketDropperUse.TankType.FLUID_TANK;
    }

    @Override
    protected void applyRenderColor(FluidStack stack) {
        MekanismRenderer.color(stack);
    }

    @Override
    protected TextureAtlasSprite getIcon(FluidStack stack) {
        return MekanismRenderer.getFluidTexture(stack, MekanismRenderer.FluidType.STILL);
    }

    public static GuiTankBar.TankInfoProvider<FluidStack> getProvider(final IExtendedFluidTank tank, final List<IExtendedFluidTank> tanks) {
        return new GuiTankBar.TankInfoProvider<FluidStack>(){

            @Override
            @Nonnull
            public FluidStack getStack() {
                return tank.getFluid();
            }

            @Override
            public int getTankIndex() {
                return tanks.indexOf(tank);
            }

            @Override
            public Component getTooltip() {
                if (tank.isEmpty()) {
                    return MekanismLang.EMPTY.translate(new Object[0]);
                }
                if (tank.getFluidAmount() == Integer.MAX_VALUE) {
                    return MekanismLang.GENERIC_STORED.translate(tank.getFluid(), MekanismLang.INFINITE);
                }
                return MekanismLang.GENERIC_STORED_MB.translate(tank.getFluid(), TextUtils.format(tank.getFluidAmount()));
            }

            @Override
            public double getLevel() {
                return (double)tank.getFluidAmount() / (double)tank.getCapacity();
            }
        };
    }
}

